// This Plugin will update the volume of the clusters for the newcell and the oldCell and will then calculate the energy due to volume of these clusters.

#include <CompuCell3D/Simulator.h>
#include <CompuCell3D/Potts3D/Potts3D.h>
#include <CompuCell3D/Automaton/Automaton.h>
using namespace CompuCell3D;

#include <iostream>
#include <string>
#include <algorithm>
#include <set>
using namespace std;

#include <CompuCell3D/Automaton/Automaton.h>
#include "ClusterVolumePlugin.h"
#include <BasicUtils/BasicClassAccessor.h>

void ClusterVolumePlugin::init(Simulator *simulator, CC3DXMLElement *_xmlData)
{
//cerr<<"*****************init cLUSTERvOLUMEpLUIN************="<<endl;
	potts = simulator->getPotts();
        automaton = potts->getAutomaton();

	potts->registerEnergyFunctionWithName(this,toString());
	xmlData=_xmlData;
	
	simulator->registerSteerableObject(this);
	update(_xmlData);
    
	bool pluginAlreadyRegisteredFlag;
	Plugin *plugin=Simulator::pluginManager.get("VolumeTracker",&pluginAlreadyRegisteredFlag); //this will load VolumeTracker plugin if it is not already loaded
	if(!pluginAlreadyRegisteredFlag)
		plugin->init(simulator);
        
        bool clusterDataTrackerAlreadyRegisteredFlag;
	clusterDataTrackerPlugin=(ClusterDataTrackerPlugin*)Simulator::pluginManager.get("ClusterDataTrackerPlugin",&clusterDataTrackerAlreadyRegisteredFlag);
	if (!clusterDataTrackerAlreadyRegisteredFlag){
		clusterDataTrackerPlugin->init(simulator,_xmlData);
	}
}


void ClusterVolumePlugin::update(CC3DXMLElement *_xmlData, bool _fullInitFlag)
{

}

double ClusterVolumePlugin::changeEnergy(const Point3D &pt,const CellG *newCell,const CellG *oldCell) 
{ 
    //cerr<<"***clusterVolmeplugin changeenergy****newCell="<<newCell<<" oldCell="<<oldCell<<endl;

	double energy = 0.0;
        //flip within same cell, no volume or targetvolume will change for cell or cluster
	if (oldCell && newCell)
            {
            if (newCell==oldCell) 
                return energy;
            }
	if (newCell)
            {
            if((newCell->type==automaton->getTypeId("vesicle"))||(newCell->type==automaton->getTypeId("vacuole")))         
                energy +=  newCell->lambdaVolume*(1 + 2 * ((int)newCell->volume - newCell->targetVolume));
            }
        if (oldCell )
            {
            if((oldCell->type==automaton->getTypeId("vesicle"))||(oldCell->type==automaton->getTypeId("vacuole")))
                energy += oldCell->lambdaVolume*(1 - 2 * ((int)oldCell->volume - oldCell->targetVolume));
            }
        
    //same cluster so nothing changes.
	if (oldCell && newCell)
            {
            if (oldCell->clusterId == newCell->clusterId) 
                {
                //cerr<<"*****************return energy 0 cLUSTERvOLUMEpLUIN************="<<endl;
                return energy;
                }
            }
	//so not of same cluster, do things for necell and oldcell if they exist. Do not change into if newcell && !oldCell, than you miss if newCell and oldCell of different clusters.
	if (newCell)
            {
            double clusterVolumeNewCell=clusterDataTrackerPlugin->getClusterVolume(newCell->clusterId);
            double clusterTargetVolumeNewCell=clusterDataTrackerPlugin->getClusterTargetVolume(newCell->clusterId);  
            double clusterLambdaVolumeNewCell=clusterDataTrackerPlugin->getClusterLambdaVolume(newCell->clusterId);
            //cerr<<"***clusterVolmeplugin cv="<<clusterLambdaVolumeNewCell<<endl;
            energy += (clusterLambdaVolumeNewCell) *(1 + 2 * (clusterVolumeNewCell - (clusterTargetVolumeNewCell))); 
            }   
         


	if (oldCell )
            {
            double clusterVolumeOldCell=clusterDataTrackerPlugin->getClusterVolume(oldCell->clusterId);
            double clusterTargetVolumeOldCell=clusterDataTrackerPlugin->getClusterTargetVolume(oldCell->clusterId);  
            double clusterLambdaVolumeOldCell=clusterDataTrackerPlugin->getClusterLambdaVolume(oldCell->clusterId);
            energy +=  clusterLambdaVolumeOldCell * (1 - 2 * (clusterVolumeOldCell - clusterTargetVolumeOldCell)); 
            }
    return energy;

}


std::string ClusterVolumePlugin::toString(){
	return "ClusterVolumePlugin";
}
std::string ClusterVolumePlugin::steerableName(){
	return toString();
}


